#!/bin/bash
# days-between.sh:     ¥   .
# : ./days-between.sh YYYY/[M]M/[D]D YYYY/[M]M/[D]D

ARGS=2                # ɾ Ű   ʿ.
E_PARAM_ERR=65        # Ű .

REFYR=1600            #  (Reference year).
CENTURY=100
DIY=365
ADJ_DIY=367           #  + fraction  ϱ ؼ.
MIY=12
DIM=31
LEAPCYCLE=4

MAXRETVAL=256         # Լ   ִ 

diff=		      # ¥     .
value=                # 밪    .
day=                  # , ,     .
month=
year=


Param_Error ()        # Ʋ ɾ Ű.
{
  echo ": `basename $0` YYYY/[M]M/[D]D YYYY/[M]M/[D]D"
  echo "       (1600/1/3  ¥ մϴ)"
  exit $E_PARAM_ERR
}  


Parse_Date ()                 # ɾ Ű Ѿ ¥ Ľ.
{
#  month=${1%%/**}
#  dm=${1%/**}                 # Day and month.
#  day=${dm#*/}
# ű: YYYY/MM/DD · ٲ.
  year=${1%%/**}
  ym=${1%/**}                 # , .
  month=${ym#*/}
  let "day = `basename $1`"   # ̸ ƴ Ȱ մϴ.
}  


check_date ()                 # ¥  ´ Ȯ.
{
  [ "$day" -gt "$DIM" ] || [ "$month" -gt "$MIY" ] || [ "$year" -lt "$REFYR" ] && Param_Error
  #   ¥ ƴ 쿡 ũƮ .
  # "or-list / and-list"  .
  # ڵ  : ¥   Ȯϰ Ȯϵ  .
}


strip_leading_zero () # ̳  տ 0   쿡 
{                     # Bash  8  ؼϱ (POSIX.2, 2.9.2.1 ) 
  val=${1#0}          #  0  ߶ ʿ䰡 ֽϴ.
  return $val
}


day_index ()          # 콺 (Gauss' Formula):
{                     # 1600 1 3Ϻ Ű Ѿ ¥ .

  day=$1
  month=$2
  year=$3

  let "month = $month - 2"
  if [ "$month" -le 0 ]
  then
    let "month += 12"
    let "year -= 1"
  fi  

  let "year -= $REFYR"
  let "indexyr = $year / $CENTURY"


  let "Days = $DIY*$year + $year/$LEAPCYCLE - $indexyr + $indexyr/$LEAPCYCLE + $ADJ_DIY*$month/$MIY + $day - $DIM"
  #  ˰  ڼ   ϼ.
  # http://home.t-online.de/home/berndt.schwerdtfeger/cal.htm


  if [ "$Days" -gt "$MAXRETVAL" ]  # Լ 256  ū  ϱ ؼ
  then                             #  256  ũٸ  ٲ.
    let "dindex = 0 - $Days"     
  else let "dindex = $Days"
  fi

  return $dindex

}  


calculate_difference ()            #  ¥ ̳   .
{
  let "diff = $1 - $2"             #  .
}  


abs ()                             # 밪
{                                  # "value"   .
  if [ "$1" -lt 0 ]                # If 
  then                             # then
    let "value = 0 - $1"           # ȣ ٲٱ,
  else                             # else
    let "value = $1"               # ״ .
  fi
}



if [ $# -ne "$ARGS" ]              # ɾ Ű   ʿ.
then
  Param_Error
fi  

Parse_Date $1
check_date $day $month $year      # ¥  ´ Ȯ.

strip_leading_zero $day           # ̳  տ  0  .
day=$?                          
strip_leading_zero $month
month=$?

day_index $day $month $year
date1=$?

abs $date1                         # 밪  Ȯ  
date1=$value                     

Parse_Date $2
check_date $day $month $year

strip_leading_zero $day
day=$?
strip_leading_zero $month
month=$?

day_index $day $month $year
date2=$?

abs $date2                         #  .
date2=$value

calculate_difference $date1 $date2

abs $diff                          #  .
diff=$value

echo $diff

exit 0
# http://buschencrew.hypermart.net/software/datedif
#  ִ 콺  C   ũƮ  .
